package breadboards;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayDeque;

import javax.swing.Timer;

public class GTurtle extends GCompound {
  
  final int DEFAULT_DELAY = 300;
  
  double size;
  Color color;
  double heading; // radians, where 0 is headed in positive x direction
                  // and positive radians rotate counter-clockwise
  double stepSize;
  double turnSize;
  GOval body;
  GOval head;
  
  boolean isPenDown;
  
  GCompound trail;
  
  Timer timer;
  ArrayDeque<String> commands;
  
  public GTurtle(double x, double y, double stepSize, double turnSize) {
    
    trail = new GCompound();
    
    commands = new ArrayDeque<String>();
    
    this.setLocation(x, y);
    
    this.color = Color.GREEN;
    this.size = 10;
    this.isPenDown = true;
    
    this.stepSize = stepSize;
    this.turnSize = turnSize;

    body = new GOval(-size,-size,2*size,2*size);
    body.setFilled(true);
    body.setFillColor(color);
    this.add(body);
    
    head = new GOval(size,-size/2.0,size,size);
    head.setFilled(true);
    head.setFillColor(Color.GREEN);
    setHeading(0);
    this.add(head);
    
    timer = new Timer(DEFAULT_DELAY,new ActionListener() {

      @Override
      public void actionPerformed(ActionEvent e) {
        if (commands.size() > 0) {
          
          String command = commands.removeFirst();
          switch (command) {
          case "turn"    : onTurn();    break;
          case "step"    : onStep();    break;
          case "pendown" : onPenDown(); break;
          case "penup"   : onPenUp();   break;
          }

        }
        
      }});
    timer.start();
  }
  
  public void forgetCommands() {
    commands = new ArrayDeque<String>();
  }
  
  public void setLocation(double x, double y) {
    forgetCommands();
    super.setLocation(x,y);
  }
  
  public void setX(double x) {
    forgetCommands();
    super.setX(x);
  }
  
  public void setY(double y) {
    forgetCommands();
    super.setX(x);
  }
  
  public double getHeading() {
    return this.heading;
  }
  
  public void setDelay(int delay) {
    this.timer.setDelay(delay);
  }
  
  public void setHeading(double heading) {
    this.heading = heading;
    double hx = 3*size*Math.cos(-heading)/2.0 - size/2.0;
    double hy = 3*size*Math.sin(-heading)/2.0 - size/2.0;
    head.setLocation(hx, hy);
  }
  
  public void penUp() {
    commands.add("penup");
  }
  
  public void penDown() {
    commands.add("pendown");
  }
  
  public void onPenDown() {
    this.isPenDown = true;
  }
  
  public void onPenUp() {
    this.isPenDown = false;
  }
  
  public GCompound getTrail() {
    return this.trail;
  }
  
  public void turn() {
    commands.add("turn");
  }
  
  public void onTurn() {
    this.setHeading(this.getHeading()+turnSize);
  }
  
  public void step() {
    commands.add("step");
  }
  
  public void onStep() {
    GPoint startPt = this.getLocation();
    this.move(stepSize*Math.cos(-heading), stepSize*Math.sin(-heading));
    GPoint endPt = this.getLocation();
    
    if (this.isPenDown) {
      GLine line = new GLine(startPt.getX(), startPt.getY(), endPt.getX(), endPt.getY());
      trail.add(line);
    }
    
  }

}
