package breadboards;

import java.awt.Color;

/**
 * Subclass of GCompound that looks like a small red spaceship
 * @author paul oser
 */
public class GSpaceship extends GCompound {
  
  private GOval shipBody;
  private GOval bubble;
  private GOval alien;
  
  /**
   * constructs a GSpaceship at the specified location
   * @param x x-coordinate of the specified location
   * @param y y-coordinate of the specified location
   */
  public GSpaceship(double x, double y) {
     shipBody = new GOval(-30,-15,60,30);
     shipBody.setFilled(true);
     shipBody.setFillColor(Color.RED);
     
     bubble = new GOval(-15,-30,30,30);
     bubble.setFilled(true);
     bubble.setFillColor(Color.WHITE);
     
     alien = new GOval(-5,-23,10,10);
     alien.setFilled(true);
     alien.setFillColor(Color.GREEN);
     
     this.add(bubble);
     this.add(alien);
     this.add(shipBody);
     
     this.setLocation(x,y);
  }

}
