package breadboards;
/**
 * Class whose objects are coordinates (x,y) where these coordinates are stored as doubles
 * @author paul oser
 */
public class GPoint {
  
  double x;
  double y;
  
  /**
   * constructs a GPoint where (x,y) = (0,0)
   */
  public GPoint() {
    this.x = 0;
    this.y = 0;
  }
  
  /** 
   * constructs a GPoint with the specified coordinates
   * @param x the specified x-coordinate
   * @param y the specified y-coordinate
   */
  public GPoint(double x, double y) {
    setLocation(x,y);
  }
  
  /**
   * returns the GPoint's x-coordinate
   * @return the GPoint's x-coordinate
   */
  public double getX() {
    return this.x;
  }
  
  /**
   * returns the GPoint's y-coordinate
   * @return the GPoint's y-coordinate
   */
  public double getY() {
    return this.y;
  }
  
  /**
   * sets the location of the GPoint to the specified location
   * @param x the specified x-coordinate
   * @param y the specified y-coordinate
   */
  public void setLocation(double x, double y) {
    this.x = x;
    this.y = y;
  }
  
  /**
   * translates the GPoint dx units to the right (left if negative) and dy units down (up if negative)
   * @param dx distance to move GPoint to the right (left if negative)
   * @param dy distance to move GPoint down (up if negative)
   */
  public void translate(double dx, double dy) {
    this.x += dx;
    this.y += dy;
  }

}
