package breadboards;

/**
 * Class whose objects are dimensions of a GObject (i.e., its height and width)
 * @author paul oser
 *
 */
public class GDimension {
  
  double width;
  double height;

  /**
   * constructs a new GDimension with zero height and zero width
   */
  public GDimension() {
    //width & height == 0
  }
  
  /**
   * constructs a new GDimension with the specified width and height
   * @param width the specified width
   * @param height the specified height
   */
  public GDimension(double width, double height) {
    this.setSize(width, height);
  }
  
  /**
   * returns the height of this GDimension
   * @return the height of this GDimension
   */
  public double getHeight() {
    return height;
  }
  
  /** 
   * returns the width of this GDimension
   * @return the width of this GDimension
   */
  public double getWidth() {
    return width;
  }
  
  /**
   * sets the dimensions of this GDimension to the specified width and height
   * @param width the specified  width
   * @param height the specified height
   */
  public void setSize(double width, double height) {
    this.width = width;
    this.height = height;
  }
}
